/////////////////////////////////////////////////////////////
// CINEMA SDK : MENU PLUGINS															 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

// example code for a sub dialog

// be sure to use a unique ID obtained from www.plugincafe.com
#define ID_SUBDIALOGTEST 1000454

#include "c4d.h"
#include "c4d_symbols.h"


class MySubDialog1 : public SubDialog
{
	virtual Bool CreateLayout(void)
	{
		GroupBegin(0,BFH_SCALEFIT|BFV_SCALEFIT,2,0,"",0);
			AddButton(1000,BFH_SCALEFIT|BFV_SCALEFIT,0,0,"SubDialog1");
			AddButton(1001,BFH_SCALEFIT|BFV_SCALEFIT,0,0,"SubDialog1");
			AddButton(1002,BFH_SCALEFIT|BFV_SCALEFIT,0,0,"SubDialog1");
			AddButton(1003,BFH_SCALEFIT|BFV_SCALEFIT,0,0,"SubDialog1");
			AddEditNumberArrows(1006,BFH_SCALEFIT);
		GroupEnd();
		return TRUE;
	}
	virtual Bool InitValues(void)
	{
		SetLong(1006,0L,0,10);
		return TRUE;
	}
	virtual Bool Command(LONG id,const BaseContainer &msg)
	{
		return TRUE;
	}
};

class MySubDialog2 : public SubDialog
{
	virtual Bool CreateLayout(void)
	{
		GroupBegin(0,BFH_SCALEFIT|BFV_SCALEFIT,2,0,"",0);
			AddStaticText(1000,BFH_SCALEFIT|BFV_SCALEFIT,0,0,"SubDialog2",BORDER_THIN_IN);
			AddStaticText(1001,BFH_SCALEFIT|BFV_SCALEFIT,0,0,"SubDialog2",BORDER_THIN_IN);
			AddStaticText(1002,BFH_SCALEFIT|BFV_SCALEFIT,0,0,"SubDialog2",BORDER_THIN_IN);
			AddStaticText(1003,BFH_SCALEFIT|BFV_SCALEFIT,0,0,"SubDialog2",BORDER_THIN_IN);
			AddStaticText(1004,BFH_SCALEFIT|BFV_SCALEFIT,0,0,"SubDialog2",BORDER_THIN_IN);
			AddStaticText(1005,BFH_SCALEFIT|BFV_SCALEFIT,0,0,"SubDialog2",BORDER_THIN_IN);
			AddEditNumberArrows(1006,BFH_SCALEFIT);
		GroupEnd();
		return TRUE;
	}
	virtual Bool InitValues(void)
	{
		SetLong(1006,0L,0,10);
		return TRUE;
	}
	virtual Bool Command(LONG id,const BaseContainer &msg)
	{
		return TRUE;
	}
};


class MainDialog : public GeDialog
{
	private:
		MySubDialog1 subdialog1;
		MySubDialog2 subdialog2;
		SubDialog    *lastdlg;

	public:
		MainDialog(void);
		virtual ~MainDialog(void);

		virtual Bool CreateLayout(void);
		virtual Bool InitValues(void);
		virtual Bool Command(LONG id,const BaseContainer &msg);
		virtual LONG Message(const BaseContainer &msg,BaseContainer &result);
};

MainDialog::MainDialog(void)
{
	lastdlg = NULL;
}

MainDialog::~MainDialog(void)
{
}

Bool MainDialog::CreateLayout(void)
{
	// first call the parent instance
	Bool res = GeDialog::CreateLayout();

	res = LoadDialogResource(DLG_SUBDIALOG,NULL,0);

	if (res)
	{
		AttachSubDialog(&subdialog1,GADGET_SUBDIALOG);
		lastdlg = &subdialog1;
	}

	return res;
}

Bool MainDialog::InitValues(void)
{
	// first call the parent instance
	if (!GeDialog::InitValues()) return FALSE;

	return TRUE;
}

Bool MainDialog::Command(LONG id,const BaseContainer &msg)
{
	switch (id)
	{
		case GADGET_SUB1:
			if (!lastdlg || !lastdlg->CheckClose())
			{
				AttachSubDialog(&subdialog1,GADGET_SUBDIALOG);
				LayoutChanged(GADGET_SUBDIALOG);
				lastdlg = &subdialog1;
			}
			break;

		case GADGET_SUB2:
			if (!lastdlg || !lastdlg->CheckClose())
			{
				AttachSubDialog(&subdialog2,GADGET_SUBDIALOG);
				LayoutChanged(GADGET_SUBDIALOG);
				lastdlg = &subdialog2;
			}
			break;
	}
	return TRUE;
}


LONG MainDialog::Message(const BaseContainer &msg,BaseContainer &result)
{
//	switch (msg.GetId())
//	{
//	}
	return GeDialog::Message(msg,result);
}

class SubDialogTest : public CommandData
{
	private:
		MainDialog dlg;
	public:
		virtual Bool Execute(BaseDocument *doc);
		virtual LONG GetState(BaseDocument *doc);
		virtual Bool RestoreLayout(void *secret);
};

LONG SubDialogTest::GetState(BaseDocument *doc)
{
	return CMD_ENABLED;
}

Bool SubDialogTest::Execute(BaseDocument *doc)
{
	return dlg.Open(TRUE,ID_SUBDIALOGTEST,-1,-1);
}

Bool SubDialogTest::RestoreLayout(void *secret)
{
	return dlg.RestoreLayout(ID_SUBDIALOGTEST,0,secret);
}

Bool RegisterSubDialog(void)
{
	// decide by name if the plugin shall be registered - just for user convenience
	String name=GeLoadString(IDS_SUBDIALOG); if (!name.Content()) return TRUE;
	return RegisterCommandPlugin(ID_SUBDIALOGTEST,name,0,NULL,"",gNew SubDialogTest);
}
